/*
 * @Author: your name
 * @Date: 2021-05-17 15:44:06
 * @LastEditTime: 2021-05-17 15:49:11
 * @LastEditors: Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: \ESB\src\mixins\esb_sql_add_mixins.js
 */
import {
  saveSqlBuilderDetail,
  getSqlSheelList,
  getSqlColumnList,
  getSqlBuilderDetail,
  createSqlForm,
  executSqlForm,
  createParams
} from '@/api/esb_global_management'

import connectorList from '@/views/esb_service/sql_builder/connector_list'
import TestSql from '@/views/esb_service/sql_builder/TestSql'

import sqlBuilderList from '@/views/esb_service/sql_builder/sqlBuilderList'

import {
  createNamespacedHelpers
} from 'vuex'
const {
  mapGetters,
  mapMutations
} = createNamespacedHelpers('app')
export default {
  components: {
    connectorList,
    TestSql,
    sqlBuilderList
  },
  data() {
    return {
      title: 'SQL构建器',
      dialogWidth: 0,
      loading: false,
      dialogVisible: false,
      connectorListVisible: false,
      sqlStr: '', // SQL表达式
      parameterList: [], // sql参数列表
      sqlDialogVisible: false,
      testSqlVisible: false,
      // 表列表
      dataSheetList: [],
      // 表列名，字段名
      columnList: [],
      flag: false,
      // 选中列名，本地缓存
      columnName: [],
      rules: {
        name: [{
          required: true,
          message: '名称不能为空',
          trigger: ['change', 'blur']
        }],
        'dataSourceMark': [{
          required: true,
          message: 'JNDI不能为空',
          trigger: ['change', 'blur']
        }]
      },
      // 操作符列表
      operatorList: [{
        name: '等于',
        key: 'EQ'
      },
      {
        name: '小于',
        key: 'LT'
      },
      {
        name: '大于',
        key: 'GT'
      },
      {
        name: '大于等于',
        key: 'GE'
      },
      {
        name: '小于等于',
        key: 'LE'
      },
      {
        name: '不等于',
        key: 'NE'
      },
      {
        name: '包含',
        key: 'LIKE'
      },
      {
        name: '不包含',
        key: 'NLIKE'
      },
      {
        name: '为空',
        key: 'NULL'
      },
      {
        name: '不为空',
        key: 'NN'
      },
      {
        name: '在...中',
        key: 'IN'
      },
      {
        name: '不在什么中',
        key: 'NIN'
      },
      {
        name: '右LIKE',
        key: 'LLIKE'
      },
      {
        name: '左LIKE',
        key: 'PLIKE'
      },
      {
        name: '在什么之间',
        key: 'BETWEEN'
      }
      ],
      paraTypeList: [{
        name: '静态值',
        key: 'static'
      },
      {
        name: '参数',
        key: 'parameter'
      },
      {
        name: '其他字段',
        key: 'otherColumn'
      }
      ],
      // 条件合并方式
      mergeList: [{
        name: 'AND',
        key: 'and'
      },
      {
        name: 'OR',
        key: 'or'
      }
      ],
      //
      // 表达式对象
      sqlBuilderConditionItem: {
        'children': [{
          'columnName': '',
          'parameterName': '',
          'id': '',
          'logic': '',
          'opt': '', // 匹配规则
          'pid': '',
          'sqlBuilderId': '', // sqlID
          'tableName': '', // 表名
          'parameterTyep': '', // 参数类型
          'customValue': '', // 自定义值
          'columnType': '' // TYPE_NAME 字段类型
        }],
        'columnName': '',
        'parameterName': '',
        'id': '',
        'logic': '',
        'opt': '', // 匹配规则
        'pid': '',
        'sqlBuilderId': '', // sqlID
        'tableName': '', // 表名
        'parameterTyep': '', // 参数类型
        'customValue': '', // 自定义值
        'columnType': '' // TYPE_NAME 字段类型
      },
      // 表单信息
      form: {
        description: '', // 构建器描述
        name: '', // sql构建器名字
        dataSourceMark: '', // 链接器地址
        operate: '', // 选择操作
        customSql: '', // 自定义sql
        id: '',
        // 表达式相关
        sqlBuilderConditionList: [{
          'children': [{
            'columnName': '',
            'parameterName': '',
            'id': '',
            'logic': '',
            'opt': '', // 匹配规则
            'pid': '',
            'sqlBuilderId': '', // sqlID
            'tableName': '', // 表名
            'parameterTyep': '', // 参数类型
            'customValue': '', // 自定义值
            'columnType': '' // TYPE_NAME 字段类型
          }],
          'columnName': '',
          'parameterName': '',
          'id': '',
          'logic': '',
          'opt': '', // 匹配规则
          'pid': '',
          'sqlBuilderId': '', // sqlID
          'tableName': '', // 表名
          'parameterTyep': '', // 参数类型
          'customValue': '', // 自定义值
          'columnType': '' // TYPE_NAME 字段类型
        }],
        // 列名相关
        sqlBuilderColumnList: [{
          'columnName': '',
          'id': '',
          'sqlBuilderId': '',
          'tableName': ''
        }],
        // 表名相关
        sqlBuilderTableList: [{
          id: '',
          joinType: '',
          objectName: '', // 表名
          sqlBuilderId: '',
          sqlBuilderJoinColumnList: [{
            columnName: '',
            id: '',
            joinColumnName: '',
            joinTableName: '',
            sqlBuilderId: '',
            sqlBuilderTableId: ''
          }]
        }]
      }
    }
  },
  props: {
    value: {
      type: Boolean,
      default: true
    },
    id: {
      type: String,
      default: ''
    },
    rowData: {
      type: Object,
      default: {}
    }
  },
  watch: {
    value(val) {
      this.dialogVisible = val
      this.form = {
        name: '', // sql构建器名字
        dataSourceMark: '', // 链接器地址
        operate: '', // 选择操作
        id: '',
        customSql: '', // 自定义sql
        // 表达式相关
        sqlBuilderConditionList: [{
          'children': [{
            'columnName': '',
            'parameterName': '',
            'id': '',
            'logic': '',
            'opt': '', // 匹配规则
            'pid': '',
            'sqlBuilderId': '', // sqlID
            'tableName': '', // 表名
            'parameterTyep': '', // 参数类型
            'customValue': '', // 自定义值
            'columnType': '' // TYPE_NAME 字段类型
          }],
          'columnName': '',
          'parameterName': '',
          'id': '',
          'opt': '', // 匹配规则
          'pid': '',
          'sqlBuilderId': '', // sqlID
          'tableName': '', // 表名
          'parameterTyep': '', // 参数类型
          'customValue': '', // 自定义值
          'columnType': '' // TYPE_NAME 字段类型
        }],
        // 列名相关
        sqlBuilderColumnList: [{
          'columnName': '',
          'id': '',
          'sqlBuilderId': '',
          'tableName': ''
        }],
        // 表名相关
        sqlBuilderTableList: [{
          id: '',
          joinType: '',
          objectName: '', // 表名
          sqlBuilderId: '',
          sqlBuilderJoinColumnList: [{
            columnName: '',
            id: '',
            joinColumnName: '',
            joinTableName: '',
            sqlBuilderId: '',
            sqlBuilderTableId: ''
          }]
        }]
      }

      if (val == true) {
        this.getSqlBuilder(this.rowData.id)
      }
    },
    dialogVisible(val) {
      // console.log(val);
      if (val) {
        // 打开后判断有没有id
        // 有id就是修改，进行获取详情
        // 无id就是新增
        // getServicePermission(this.id)
      }
      this.$emit('closeEditDialog', val)
    },
    rowData(val) {
      // 传过来的表单数据
      // this.form.name = val.name;
      // this.form.dataSourceMark = val.dataSourceMark;
      // this.form.id = val.id;
      // 根据id获取详情
      // this.getSqlBuilder(val.id)

    },
    // columnName(val){//列名发生改变
    //   // console.log(val)
    //   this.columnNameChange(val)
    // },
    id(val) {
      // console.log(val);
    },
    // columnList(){//列名发生改变
    //     console.log(222)
    //     this.columnNameChange(this.columnName)
    // },
    'form.dataSourceMark'(newVal, oldVal) {
      if (newVal != oldVal && oldVal != '') {
        this.form.operate = ''
        this.operateTypeChange('')
      }
    }
  },
  computed: {
    ...mapGetters(['projectID'])
  },
  created() {
    // 初始化调用
    this.setDialogWidth()
  },
  mounted() {
    // 监听窗口宽度
    window.onresize = () => {
      return (() => {
        this.setDialogWidth()
      })()
    }
  },
  methods: {
    ...mapMutations(['setPayloadType']),

    // 弹窗宽度
    setDialogWidth() {
      var val = document.body.clientWidth
      const def = 800 // 宽度最小为800,可修改
      // 窗口宽度小于默认宽度时，将弹框看度设置为50%,可修改
      if (val < def) {
        this.dialogWidth = '800px'
      } else {
        // 窗口宽度大于默认宽度1200时，将弹框设置为400宽度,可修改
        this.dialogWidth = '85%'
      }
    },
    // 关闭弹窗
    closeDiola() {
      this.setFormNull()
      this.$emit('closeEditDialog', false)
    },
    // 获取适配器列表，类型为DB
    // 打开
    // 关闭
    closeconnectorListDialog(val) {
      this.connectorListVisible = val
    },
    dataSourceMarkChange() {

    },
    getConnerctorName(val) {
      this.connectorListVisible = false
      this.form.dataSourceMark = val.mark
    },

    // 操作类型改变
    operateTypeChange(val) {
      this.form.sqlBuilderTableList[0].objectName = ''
      this.columnName = []

      const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))
      this.form.sqlBuilderConditionList = []
      this.form.sqlBuilderConditionList.push(newItem)
      if (val != '') {
        this.getSqlSheel(val)
      }
    },
    // 获取表名
    getSqlSheel(val) {
      // dataSourceMark   操作类型
      // console.log(this.rowData);
      getSqlSheelList({
        operate: this.form.operate,
        dataName: this.form.dataName,
        dataSourceMark: this.form.dataSourceMark
      })
        .then((rt) => {
          // console.log(rt);
          if (rt.status == '200') {
            this.dataSheetList = rt.data
            // console.log(this.form.sqlBuilderTableList[0].objectName)
            if (this.form.sqlBuilderTableList[0].objectName != '') {
              // 获取字段
              this.getSqlColumn(this.form.sqlBuilderTableList[0].objectName)
            }
          }
        })
        .catch((err) => {
          console.log(err)
        })
    },
    // 表名改变
    tableNameChange(val) {
      // console.log(val);
      // 清空
      // 列名列表
      this.columnName = []
      const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))
      this.form.sqlBuilderConditionList = []
      this.form.sqlBuilderConditionList.push(newItem)
      this.form.sqlBuilderColumnList = [{
        'columnName': '',
        'id': '',
        'sqlBuilderId': '',
        'tableName': ''
      }]
      if (val != '') {
        this.getSqlColumn(val)
      }
    },
    // 获取字段名
    getSqlColumn(val) {
      // console.log(val);
      getSqlColumnList({
        operate: this.form.operate,
        dataSourceMark: this.form.dataSourceMark,
        TABLE_NAME: val
      })
        .then((rt) => {
          // console.log(rt);
          var that = this
          if (rt.status == '200') {
            this.columnList = rt.data
            //  // this.columnName=[]
            var columnNameList = []
            this.form.sqlBuilderColumnList.map((item, index) => {
              //   //   //保存跟获取详情的字段名不一致，这里做下处理
              //   //   this.columnName.push(item.columnName)
              for (let i = 0; i < rt.data.length; i++) {
                if (rt.data[i].COLUMN_NAME == item.columnName) {
                  columnNameList.push(rt.data[i])
                }
              }
            })
            that.toggleSelection(columnNameList, rt.data)
          }
        })
        .catch((err) => {
          console.log(err)
        })
    },
    // 自动 ，字段名发生变化，默认选中
    toggleSelection(rows, allList) {
      var that = this
      this.flag = true
      this.$refs.multipleTableMale.clearSelection()
      if (rows.length > 0) {
        this.$nextTick(() => {
          that.form.sqlBuilderColumnList = []
          rows.forEach(row => {
            that.$refs.multipleTableMale.toggleRowSelection(row, true)
            that.form.sqlBuilderColumnList.push({
              columnName: row.COLUMN_NAME,
              sqlBuilderId: that.form.id,
              tableName: that.form.sqlBuilderTableList[0].objectName,
              columnType: row.TYPE_NAME
            })
          })
          // 对数据进行处理

          that.columnName = this.form.sqlBuilderColumnList
          that.flag = false
        })
      } else {
        this.$nextTick(() => {
          that.form.sqlBuilderColumnList = []
          allList.forEach(row => {
            that.$refs.multipleTableMale.toggleRowSelection(row, true)
            that.form.sqlBuilderColumnList.push({
              columnName: row.COLUMN_NAME,
              sqlBuilderId: that.form.id,
              tableName: that.form.sqlBuilderTableList[0].objectName,
              columnType: row.TYPE_NAME
            })
          })
          // 对数据进行处理

          that.columnName = this.form.sqlBuilderColumnList
          that.flag = false
        })
      }
    },
    // 手动，字段名发生变化
    handleSelectionChangeMale(val) {
      if (this.flag) return // 防止自动选中触发多次

      var that = this
      that.form.sqlBuilderColumnList = []
      // 置空
      if (val.length < 1) {
        this.form.sqlBuilderConditionList = []
        const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))
        this.form.sqlBuilderConditionList.push(newItem)
        return false
      }
      // 如果没有选
      if (this.columnList.length < 1) {
        return false
      }
      // 对数据进行处理
      val.filter((item) => {
        this.form.sqlBuilderColumnList.push({
          columnName: item.COLUMN_NAME,
          sqlBuilderId: this.form.id,
          tableName: this.form.sqlBuilderTableList[0].objectName,
          columnType: item.TYPE_NAME
        })
      })
      that.columnName = this.form.sqlBuilderColumnList
    },

    // 字段名发生变化,已弃用
    columnNameChange(val) {
      var that = this
      this.form.sqlBuilderColumnList = []

      if (val == '') {
        this.form.sqlBuilderConditionList = []
        const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))
        this.form.sqlBuilderConditionList.push(newItem)
        return false
      }
      // console.log(this.columnList)
      if (this.columnList.length < 1) {
        return false
      }

      val.filter((item) => {
        that.columnList.map((cItem) => {
          if (item == cItem.COLUMN_NAME) {
            this.form.sqlBuilderColumnList.push({
              columnName: cItem.COLUMN_NAME,
              sqlBuilderId: this.form.id,
              tableName: this.form.sqlBuilderTableList[0].objectName,
              columnType: cItem.TYPE_NAME

            })
          }
        })
      })

      // console.log(this.form)
    },
    disableCheck(row) {
      if (row.PRIMARYKEY) {
        return false
      } else {
        return true
      }
    },
    // 新增字段
    addNewList() {
      const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))

      this.form.sqlBuilderConditionList.push(newItem)
    },
    // 表达式相关
    addChildren(index) {
      const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))
      this.form.sqlBuilderConditionList[index].children.push(newItem)
    },
    reduceChildren(index, cIndex) {
      this.form.sqlBuilderConditionList[index].children.splice(cIndex, 1)
    },
    // 获取详情
    getSqlBuilder(id) {
      getSqlBuilderDetail(id)
        .then((rt) => {
          if (rt.status === '200' && rt.data) {
            this.form = rt.data

            // 如果表为空，添加默认数据
            if (this.form.sqlBuilderTableList.length == 0) {
              this.form.sqlBuilderTableList = [{
                id: '',
                joinType: '',
                objectName: '', // 表名
                sqlBuilderId: '',
                sqlBuilderJoinColumnList: [{
                  columnName: '',
                  id: '',
                  joinColumnName: '',
                  joinTableName: '',
                  sqlBuilderId: '',
                  sqlBuilderTableId: ''
                }]
              }]
            }
            // 如果  操作不为空
            if (this.form.operate != '') {
              this.getSqlSheel()
            }
          }
        })
        .catch(() => {})
    },
    // 删除表达式
    deleteLine(index) {
      this.form.sqlBuilderConditionList.splice(index, 1)
      // 如果全部删除，添加一个空的数组
      if (this.form.sqlBuilderConditionList.length == 0) {
        const newItem = JSON.parse(JSON.stringify(this.sqlBuilderConditionItem))
        this.form.sqlBuilderConditionList.push(newItem)
      }
    },
    // sql预览
    preview() {
      // createSql({
      //   id:this.form.id
      // })
      createSqlForm(this.form)
        .then((rt) => {
          this.sqlStr = rt.data.sql
          this.sqlDialogVisible = true
        })
    },
    // 自定义sql测试
    customSqlTest() {
      this.sqlStr = this.form.customSql
      this.sqlTest()
    },
    // sql测试
    sqlTest() {
      // 获取sql参数
      createParams({
        'sql': this.sqlStr
      })
        .then((rt) => {
          if (rt.status == 200) {
            // 返回成功
            if (rt.data.paramList.length > 0) {
              // 有参数
              rt.data.paramList.map(function(item) {
                item['paramValue'] = ''
              })
              this.parameterList = rt.data.paramList
              this.testSqlVisible = true
            } else {
              // 没有有效参数
              this.parameterList = []
              this.sqlExecut()
            }
          }
        })
    },
    getStatus(list) {
      this.testSqlVisible = false
      this.parameterList = list
      this.sqlExecut()
    },
    // 执行sql，测试
    sqlExecut() {
      executSqlForm({
        sql: this.sqlStr,
        dataSourceMark: this.form.dataSourceMark,
        paramList: this.parameterList
      })
        .then((rt) => {
          if (rt.status == 200 || rt.data.result == true) {
            this.$message.success('SQL测试成功')
          } else {
            this.$message.warning('SQL测试失败')
          }
        })
    },
    // 提交表单
    onSubmit() {
      this.$refs['form'].validate((valid) => {
        if (valid) {
          if (this.form.operate != 'Custom') {
            this.form.customSql = ''
          } else {
            this.form.sqlBuilderConditionList = [{
              'children': [{
                'columnName': '',
                'parameterName': '',
                'id': '',
                'logic': '',
                'opt': '', // 匹配规则
                'pid': '',
                'sqlBuilderId': '', // sqlID
                'tableName': '', // 表名
                'parameterTyep': '', // 参数类型
                'customValue': '', // 自定义值
                'columnType': '' // TYPE_NAME 字段类型
              }],
              'columnName': '',
              'parameterName': '',
              'id': '',
              'logic': '',
              'opt': '', // 匹配规则
              'pid': '',
              'sqlBuilderId': '', // sqlID
              'tableName': '', // 表名
              'parameterTyep': '', // 参数类型
              'customValue': '', // 自定义值
              'columnType': '' // TYPE_NAME 字段类型
            }]
            // 列名相关
            this.form.sqlBuilderColumnList = [{
              'columnName': '',
              'id': '',
              'sqlBuilderId': '',
              'tableName': ''
            }]
            // 表名相关
            this.form.sqlBuilderTableList = [{
              id: '',
              joinType: '',
              objectName: '', // 表名
              sqlBuilderId: '',
              sqlBuilderJoinColumnList: [{
                columnName: '',
                id: '',
                joinColumnName: '',
                joinTableName: '',
                sqlBuilderId: '',
                sqlBuilderTableId: ''
              }]
            }]
          }
          saveSqlBuilderDetail(this.form).then((rt) => {
            if (rt.status === '200') {
              this.$message({
                message: '提交成功',
                type: 'success'
              })
              this.setFormNull()
              this.$emit('confirmEdit')
            }
          })
            .catch((err) => {
              console.log(err)
              // 全部为空也不会报错
            })
        }
      })
    },
    setFormNull() {
      // 初始化form表单
      this.form = {
        name: '', // sql构建器名字
        dataSourceMark: '', // 链接器地址
        operate: '', // 选择操作
        customSql: '', // 自定义sql
        id: '',
        // 表达式相关
        sqlBuilderConditionList: [{
          'children': [{
            'columnName': '',
            'parameterName': '',
            'id': '',
            'logic': '',
            'opt': '', // 匹配规则
            'pid': '',
            'sqlBuilderId': '', // sqlID
            'tableName': '', // 表名
            'parameterTyep': '', // 参数类型
            'customValue': '', // 自定义值
            'columnType': '' // TYPE_NAME 字段类型
          }],
          'columnName': '',
          'parameterName': '',
          'id': '',
          'opt': '', // 匹配规则
          'pid': '',
          'sqlBuilderId': '', // sqlID
          'tableName': '', // 表名
          'parameterTyep': '', // 参数类型
          'customValue': '', // 自定义值
          'columnType': '' // TYPE_NAME 字段类型
        }],
        // 列名相关
        sqlBuilderColumnList: [{
          'columnName': '',
          'id': '',
          'sqlBuilderId': '',
          'tableName': ''
        }],
        // 表名相关
        sqlBuilderTableList: [{
          id: '',
          joinType: '',
          objectName: '', // 表名
          sqlBuilderId: '',
          sqlBuilderJoinColumnList: [{
            columnName: '',
            id: '',
            joinColumnName: '',
            joinTableName: '',
            sqlBuilderId: '',
            sqlBuilderTableId: ''
          }]
        }]
      }
    }
  }
}
