import { listLogLevelget } from '@/api/esb_service'
import { createNamespacedHelpers } from 'vuex'
const { mapGetters, mapMutations } = createNamespacedHelpers('app')
export default {
  data() {
    return {
      dialogVisible: false,
      dialogLoading: false,
      formData: {},
      flowStageList: [],
      flag: true,
      haveLog: false
    }
  },
  props: {
    value: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    ...mapGetters(['currentOperate', 'currenStageData', 'currenStageList', 'currenStageIndex', 'operatePanelData', 'logLevelList'])
  },
  watch: {
    dialogVisible(val) {
      this.$emit('input', val)
    },
    haveLog(val) {
      if (val && this.logLevelList.length === 0) {
        this.listLogLevelget()
      }
    },
    flowStageList: {
      handler: function(val) {
        if (this.value) {
          this.loopOperate(val)
        }
      },
      deep: true
    }
  },
  methods: {
    ...mapMutations(['setLogLevelList', 'setCurrenStageIndex', 'setCurrenStageData']),
    listLogLevelget() {
      listLogLevelget().then((rt) => {
        if (rt.status === '200' && rt.data) {
          this.setLogLevelList(rt.data)
        }
      }).catch(() => {
      })
    },
    loopOperate(list) {
      for (let i = 0, len = list.length; i < len; i++) {
        const item = list[i]
        if (item.type === 'LogNodeDTO') {
          this.haveLog = true
        }
        if (item.subNodes && item.subNodes.length > 0) {
          this.loopOperate(item.subNodes)
        }
      }
    },
    handleOperate() {
      const item = {}
      this.$set(item, 'type', this.currentOperate)
      this.$set(item, 'flowId', this.flowId)
      this.$set(item, 'enable', true)
      this.$set(item, 'subNodes', [
        // {
        //   type: 'LogNodeDTO',
        //   flowId: this.flowId,
        //   subNodes: []
        // }
      ])
      console.log(this.currentOperate,'222222222222222222222')
      if (this.currentOperate === 'DeleteOperate') {
        this.currenStageList.splice(this.currenStageIndex, 1)
        return
      }
      if (this.currentOperate === 'AddElseIf') { // 当前选中的操作
        this.$set(item, 'type', this.currenStageData.type)
        if (this.operatePanelData.type === 'AddIfElseAll') { // 操作面板类型
          this.currenStageData.elseIfNodes.unshift(item)
        } else {
          this.currenStageData.elseIfNodes.splice(this.currenStageIndex + 1, 0, item)
        }
        return
      }
      if (this.currentOperate === 'AddElse') { // 当前选中的操作
        this.$set(this.currenStageData, 'defaultNode', [])
        return
      }
      if (this.currentOperate === 'DeleteCondition') { // 当前选中的操作
        if (this.operatePanelData.type === 'DeleteCondition') {
          this.$set(this.currenStageData, 'defaultNode', null)
        } else if (this.operatePanelData.type === 'AddIfElse' || this.operatePanelData.type === 'OnlyAddElseIf') {
          this.currenStageData.elseIfNodes.splice(this.currenStageIndex, 1)
        }
        return
      }
      // 上移
      if (this.currentOperate === 'MoveUpOperate') {
        this.zIndexUp(this.currenStageList, this.currenStageIndex)
        return
      }
      // 下移
      if (this.currentOperate === 'MoveDownOperate') {
        this.zIndexDown(this.currenStageList, this.currenStageIndex)
        return
      }
      if (this.currentOperate === 'CopyOperate') {
        console.log(this.flowStageList, '点击复制出现的东西',this.currenStageList)
        this.copyItem(this.currenStageList, this.currenStageIndex)
        return
      }
      if (this.currentOperate === 'PasteOperate') {
        console.log(77777, this.currenStageData)
        this.currenStageList.splice(this.currenStageIndex + 1, 0, this.currenStageData)
        this.setCurrenStageData({})
        // this.copyItem(this.currenStageList, this.currenStageIndex)
        return
      }
      if (this.currenStageIndex !== null && this.currenStageIndex !== undefined && this.currenStageIndex >= 0) {
        this.currenStageList.splice(this.currenStageIndex + 1, 0, item)
      } else {
        this.currenStageList.unshift(item)
        console.log(this.currenStageList,item,'打印item跟current')
      }
    },
    verifyRequired(list) {
      for (let i = 0, len = list.length; i < len; i++) {
        const item = list[i]
        // if (item.stage === 'request' && item.type === 'ReportNodeDTO') {
        //   if (!item.level) {
        //     this.$message({
        //       message: '审计日志：事物不能为空',
        //       type: 'error'
        //     })
        //     this.flag = false
        //     return
        //   }
        //   if (!item.level) {
        //     this.$message({
        //       message: '审计日志：调用系统不能为空',
        //       type: 'error'
        //     })
        //     this.flag = false
        //     return
        //   }
        // }
        if (item.type === 'LogNodeDTO') {
          if (!item.level) {
            this.$message({
              message: '日志：严重性级别不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'LoopNodeDTO') {
          if (!item.loopRuleExpr || !item.loopRuleExpr.valueExpr) {
            this.$message({
              message: 'For Each：表达式不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'ChoiceNodeDTO') {
          if (!item.contentExpr || !item.contentExpr.valueExpr) {
            this.$message({
              message: 'If...Then...：条件不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'AssignNodeDTO') {
          if (!item.contentExpr || !item.contentExpr.valueExpr) {
            this.$message({
              message: '分配：表达式不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
          if (!item.variable) {
            this.$message({
              message: '分配：变量不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'InsertNodeDTO') {
          if (!item.variable) {
            this.$message({
              message: '插入：变量不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
          if (!item.contentExpr || !item.contentExpr.valueExpr) {
            this.$message({
              message: '插入：表达式不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'ReplaceNodeDTO') {
          if (!item.contentExpr || !item.contentExpr.valueExpr) {
            this.$message({
              message: '替换：表达式不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
          if (!item.variable) {
            this.$message({
              message: '替换：变量不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'ConvertNodeDTO') {
          if (!item.contentExpr || !item.contentExpr.valueExpr) {
            this.$message({
              message: '转换：表达式不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
          if (!item.variable) {
            this.$message({
              message: '转换：变量名不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'RouteNodeDTO') {
          if (!item.name) {
            this.$message({
              message: '服务标注：服务不能为空',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.type === 'RouteOptionNodeDto') {
          if ((!item.httpmdthod && item.isHttpMethod) || (!item.uri && item.isUseUri) || (!item.relativePath && item.isUseRelativePath) || (!item.fffff && item.aaaaa) || (!item.level && item.bbbbb)) {
            this.$message({
              message: '路由选项：请填写必填选项',
              type: 'error'
            })
            this.flag = false
            return
          }
          if (item.formdatas && item.formdatas.length < 1 && item.isFormData) {
            this.$message({
              message: '路由选项：formdata必须填写一项',
              type: 'error'
            })
            this.flag = false
            return
          }
          if (!item.isQueryParam && item.isQueryParam) {
            this.$message({
              message: '路由选项：queryparam必须填写一项',
              type: 'error'
            })
            this.flag = false
            return
          }
        }
        if (item.subNodes && item.subNodes.length > 0) {
          this.verifyRequired(item.subNodes)
        }
        if (item.elseIfNodes && item.elseIfNodes.length > 0) {
          this.verifyRequired(item.elseIfNodes)
        }
      }
    },
    /**
     * 数组元素交换位置
     * @param {array} arr 数组
     * @param {number} index1 添加项目的位置
     * @param {number} index2 删除项目的位置
     * index1和index2分别是两个数组的索引值，即是两个要交换元素位置的索引值，如1，5就是数组中下标为1和5的两个元素交换位置
     */
    swapArray(arr, index1, index2) {
      arr[index1] = arr.splice(index2, 1, arr[index1])[0]
      return arr
    },
    // 下移 将当前数组index索引与后面一个元素互换位置，向数组后面移动一位
    zIndexDown(arr, index) {
      if (index + 1 !== arr.length) {
        this.swapArray(arr, index, index + 1)
      } else {
        alert('已经处于底部，无法下移')
      }
    },
    // 上移 将当前数组index索引与前面一个元素互换位置，向数组前面移动一位
    zIndexUp(arr, index) {
      if (index !== 0) {
        this.swapArray(arr, index, index - 1)
      } else {
        alert('已经处于顶部，无法上移')
      }
    },
    copyItem(arr, index) {
      // let item
      // if (!index) {
      //   item = arr.type
      // } else {
      //   item = JSON.parse(JSON.stringify(arr[index].type))
      // }
      const item = JSON.parse(JSON.stringify(arr[index]))
      this.setCurrenStageData(item)
      console.log(item,arr[index],'复制完毕')
    }
  },
  mounted() {
  }
}
