const esbServiceRoutes = [
  {
    name: 'esbService',
    path: '/esb_service',
    meta: { title: 'ESB服务', icon: 'icon-shouye2', isNav: true },
    redirect: '/esb_service/full_page',
    // redirect: '/esb_service/agency_service',
    component: resolve => require(['../../views/layout'], resolve),
    children: [
      {
        name: 'esbServiceFullPage',
        path: '/esb_service/full_page',
        meta: { title: '首页', isNav: true },
        component: resolve => require(['../../views/esb_service/full_page'], resolve)
      },
      // {
      //   name: 'esbServiceAgencyService',
      //   path: '/esb_service/project_list',
      //   meta: { title: '项目列表', isNav: true },
      //   component: resolve => require(['../../views/esb_service/project_list'], resolve)
      // },
      {
        name: 'esbServiceAgencyService',
        path: '/esb_service/agency_service',
        meta: { title: '代理服务', isNav: true },
        component: resolve => require(['../../views/esb_service/agency_service'], resolve)
      }
      // {
      //   name: 'esbServiceBusinessService',
      //   path: '/esb_service/business_service',
      //   meta: { title: '业务服务', isNav: true },
      //   component: resolve => require(['../../views/esb_service/business_service'], resolve)
      // },
      // {
      //   name: 'esbServiceMessageFlow',
      //   path: '/esb_service/message_flow',
      //   meta: { title: '消息流', isNav: true },
      //   component: resolve => require(['../../views/esb_service/message_flow'], resolve)
      // },
      // {
      //   name: 'esbServiceConnector',
      //   path: '/esb_service/connector',
      //   meta: { title: '适配器', isNav: true },
      //   component: resolve => require(['../../views/esb_service/connector'], resolve)
      // },
      // {
      //   name: 'esbServiceResourceFile',
      //   path: '/esb_service/resource_file',
      //   meta: {
      //     title: '资源文件', isNav: true, children: [
      //       { icon: 'poll', title: 'wsdl', to: '/esb_service/resource_file?type=wsdl' },
      //       { icon: 'poll', title: 'xslt', to: '/esb_service/resource_file?type=xslt' },
      //       { icon: 'poll', title: 'jsonata', to: '/esb_service/resource_file?type=jsonata' },
      //       { icon: 'poll', title: 'sql', to: '/esb_service/resource_file?type=sql' },
      //       { icon: 'poll', title: 'json schema', to: '/esb_service/resource_file?type=jsd' },
      //       { icon: 'poll', title: 'xml schema', to: '/esb_service/resource_file?type=xsd' }
      //     ]
      //   },
      //   component: resolve => require(['../../views/esb_service/resource_file'], resolve)
      // },

    ]
  },
  // 项目列表
  {
    name: 'project',
    path: '/project_list',
    // path: '/esb_service',
    meta: { title: '项目', icon: 'icon-shouye2', isNav: true },
    redirect: '/project_list/project_list',
    component: resolve => require(['../../views/layout'], resolve),
    children: [
      {
        name: 'projectPage',
        path: '/project_list/project_page',
        meta: { title: '项目首页', isNav: true },
        component: resolve => require(['../../views/esb_service/project_page'], resolve)
      },
      {
        name: 'projectList',
        path: '/project_list/project_list',
        meta: { title: '项目列表', isNav: true },
        component: resolve => require(['../../views/esb_service/project_list'], resolve)
      },
      {
        name: 'projectDetaile',
        path: '/project_list/project_detaile',
        meta: { title: '项目详情', isNav: true },
        redirect: '/project_list/agency_service',
        component: resolve => require(['../../views/esb_service/project_detaile'], resolve)
      },
      {
        name: 'nodeManage',
        path: '/project_list/node_manage',
        meta: { title: '节点管理', isNav: true },
        component: resolve => require(['../../views/esb_service/node_manage'], resolve)
      },
      {
        name: 'areaManage',
        path: '/project_list/area_manage',
        meta: { title: '域管理', isNav: true },
        component: resolve => require(['../../views/esb_service/area_manage'], resolve)
      },
      {
        name: 'statusManage',
        path: '/project_list/status_manage',
        meta: { title: '状态码', isNav: true },
        component: resolve => require(['../../views/esb_service/status_manage'], resolve)
      },
      // 修改后
      {
        name: 'esbServiceAgencyService',
        path: '/project_list/agency_service',
        meta: { title: '代理服务', isNav: true },
        component: resolve => require(['../../views/esb_service/agency_service'], resolve)
      },
      {
        name: 'esbServiceBusinessService',
        path: '/project_list/business_service',
        meta: { title: '业务服务', isNav: true },
        component: resolve => require(['../../views/esb_service/business_service'], resolve)
      },
      {
        name: 'esbServiceMessageFlow',
        path: '/project_list/message_flow',
        meta: { title: '消息流', isNav: true },
        component: resolve => require(['../../views/esb_service/message_flow'], resolve)
      },
      {
        name: 'esbServiceConnector',
        path: '/project_list/connector',
        meta: { title: '适配器', isNav: true },
        component: resolve => require(['../../views/esb_service/connector'], resolve)
      },
      {
        name: 'esbServiceResourceFile',
        path: '/project_list/resource_file',
        meta: {
          title: '资源文件',
          isNav: true,
          children: [
            { icon: 'poll', title: 'wsdl', to: '/project_list/resource_file?type=wsdl' },
            { icon: 'poll', title: 'xslt', to: '/project_list/resource_file?type=xslt' },
            { icon: 'poll', title: 'jsonata', to: '/project_list/resource_file?type=jsonata' },
            { icon: 'poll', title: 'sql', to: '/project_list/resource_file?type=sql' },
            { icon: 'poll', title: 'JSON Schema', to: '/project_list/resource_file?type=jsd' },
            { icon: 'poll', title: 'XML Schema', to: '/project_list/resource_file?type=xsd' }
          ]
        },
        component: resolve => require(['../../views/esb_service/resource_file'], resolve)
      },
      {
        name: 'account',
        path: '/project_list/account',
        meta: { title: '账户', isNav: true, parentTitle: '资源文件' },
        component: resolve => require(['../../views/esb_service/account'], resolve)
      },
      {
        name: 'sqlBuilder',
        path: '/project_list/sql_builder',
        meta: { title: 'SQL构建器', isNav: true, parentTitle: '资源文件' },
        component: resolve => require(['../../views/esb_service/sql_builder'], resolve)
      }
    ]
  }
]
export default esbServiceRoutes
