import Vue from 'vue'
import Router from 'vue-router'
import store from '../store'
import appRoutes from './app'
import esbServiceRoutes from './esb_service'
import systemManageRoutes from './system_manage'
import globalManageRoutes from './global_configuration'
import systemConfigRoutes from './system_config'
import searchRoutes from './search'

// 获取原型对象上的push函数
const originalPush = Router.prototype.push
// 修改原型对象中的push方法
Router.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}

Vue.use(Router)

export const businessRoutes = [
  ...esbServiceRoutes,
  ...systemManageRoutes,
  ...globalManageRoutes,
  ...systemConfigRoutes,
  ...searchRoutes
]

const router = new Router({
  routes: [
    ...businessRoutes,
    ...appRoutes
  ]
})
router.beforeEach((to, from, next) => {
  const isLogin = store.state.app.userInfo.id
  if (!isLogin && to.path !== '/login') {
    next('/login')
  } else {
    next()
  }
})

router.afterEach(route => {
})
export default router
