import { businessRoutes } from '@/router'
const app = {
  namespaced: true,
  state: {
    userInfo: {},
    menuList: null,
    servemenuList: null,
    tabList: [],
    pageConfig: {
      showBanner: true,
      showBreadCrumb: true,
      showLeftMenu: true,
      showLogo: false,
      leftMenuPrepend: [],
      leftMenuAppend: [],
      pageStyle: {}
    },
    themeColor: '',
    isCollapse: false,
    activeIndex: '/',
    navRecords: [
      {
        active: true,
        name: 'homePage',
        title: '首页',
        keepAlive: false
      }
    ],
    operatePanelData: {
      isShow: false,
      coord: {
        top: 0,
        left: 0
      },
      type: ''
    },
    currentOperate: null,
    currenStageData: null, // 面板配置数据
    currenStageList: null, // 消息流数据
    currenStageIndex: null, // 当前点击的面板列表的index
    logLevelList: [], // 日志数据
    operateNode: [], // 操作面板的列表数据
    payloadType: '', // 当前消息流的报文格式
    projectID: null, // 选中项目的id
    projectName: null// 选中项目的name
  },
  getters: {
    showBanner: state => state.pageConfig.showBanner,
    showBreadCrumb: state => state.pageConfig.showBreadCrumb,
    showLogo: state => state.pageConfig.showLogo,
    pageStyle: state => state.pageConfig.pageStyle,
    tabList: (state) => {
      state.tabList.forEach(item => {
        businessRoutes.forEach(val => {
          if (item.url === val.path) {
            item.meta = val.meta
            item.meta.title = item.name
            item.name = val.name
            val.meta.id = item.id
            val.meta.title = item.meta.title
            if (item.subNodes) {
              item.subNodes.forEach(item2 => {
                val.children.forEach(val2 => {
                  if (item2.url === val2.path) {
                    item2.meta = val2.meta
                    item2.meta.title = item2.name
                    item2.name = val2.name
                    val2.meta.title = item2.meta.title
                  }
                })
              })
            }
          }
        })
      })
      return state.tabList
    },
    menuList: (state) => {
      if (!state.menuList) {
        state.menuList = businessRoutes.filter(item => {
          const isNav = item.meta.isNav
          if (isNav) {
            item.children = item.children.filter(child => child.meta.isNav)
          }
          return isNav
        })
      }
      return state.menuList
    },
    servemenuList: (state) => {
      if (!state.servemenuList) {
        state.servemenuList = businessRoutes.filter(item => {
          const isNav = item.meta.isNav
          if (isNav) {
            item.children = item.children.filter(child => child.meta.isNav)
          }
          return isNav
        })
      }
      return state.servemenuList
    },
    themeColor: state => state.themeColor,
    isCollapse: state => state.isCollapse,
    navRecords: state => state.navRecords,
    activeIndex: state => state.activeIndex,
    operatePanelData: state => state.operatePanelData,
    currentOperate: state => state.currentOperate,
    currenStageData: state => state.currenStageData,
    currenStageList: state => state.currenStageList,
    currenStageIndex: state => state.currenStageIndex,
    logLevelList: state => state.logLevelList,
    operateNode: state => state.operateNode,
    payloadType: state => state.payloadType,
    projectID: state => state.projectID,
    projectName: state => state.projectName
  },
  mutations: {
    logout(state) {
      state.userInfo = {}
    },
    setTabList(state, payload) {
      state.tabList = payload
    },
    setMenuList(state, payload) {
      state.menuList = payload
    },
    servemenuList(state, payload) {
      state.servemenuList = payload
    },
    setPageConfig(state, config) {
      Object.assign(state.pageConfig, config)
    },
    setUserInfo(state, data) {
      state.userInfo = data
    },
    setThemeColor(state, payload) {
      state.themeColor = payload
    },
    setIsCollapse(state, data) {
      state.isCollapse = data
    },
    setNavRecords(state, payload) {
      state.navRecords = payload
    },
    setActiveIndex(state, payload) {
      state.activeIndex = payload
    },
    setOperatePanelData(state, payload) {
      state.operatePanelData = payload
    },

    setCurrentOperate(state, payload) {
      state.currentOperate = payload
    },
    setCurrenStageData(state, payload) {
      state.currenStageData = payload
    },

    setCurrenStageList(state, payload) {
      state.currenStageList = payload
    },
    setCurrenStageIndex(state, payload) {
      state.currenStageIndex = payload
    },
    setLogLevelList(state, payload) {
      state.logLevelList = payload
    },
    setOperateNode(state, payload) {
      state.operateNode = payload
    },
    setPayloadType(state, payload) {
      state.payloadType = payload
    },
    setProjectID(state, payload) {
      state.projectID = payload
    },
    setProjectName(state, payload) {
      state.projectName = payload
    }
  },
  actions: {
  }
}
export default app
