import Vue from 'vue'
import Vuex from 'vuex'
import createPersistedState from 'vuex-persistedstate'

import app from './app'
import home from './home'

Vue.use(Vuex)

const store = new Vuex.Store({
  modules: {
    app,
    home
  },
  plugins: [createPersistedState({
    key: 'esb_pc_user_info',
    storage: window.localStorage,
    reducer(state) {
      return {
        app: {
          userInfo: state.app.userInfo
        }
      }
    }
  }), createPersistedState({
    key: 'esb_pc_nav_records',
    storage: window.sessionStorage,
    reducer(state) {
      return {
        app: {
          navRecords: state.app.navRecords
        }
      }
    }
  }), createPersistedState({
    key: 'esb_pc_theme_color',
    storage: window.localStorage,
    reducer(state) {
      return {
        app: {
          themeColor: state.app.themeColor
        }
      }
    }
  })]
})
export default store
