import store from '@/store'
import axios from 'axios'
import { Message } from 'element-ui'
// 让ajax携带cookie
axios.defaults.withCredentials = true
const service = axios.create({
  baseURL: process.env.VUE_APP_HOST_URL + process.env.VUE_APP_BASE_URL,
  // timeout: 50000
  timeout: 120000
})

const isArray = data => Object.prototype.toString.call(data) === '[object Array]'

const showToast = (toast, data, msg) => {
  if (toast) {
    const { status, message } = data
    const isToastArray = isArray(toast)
    const needToast = (isToastArray && toast.indexOf(status) === -1) || (!isToastArray && toast)
    if (needToast) {
      if (status === '200' || data.data === 0) {
        if (message) {
          Message.success(message === 'success' ? '操作成功' : message)
        }
      } else {
        Message.error(message || msg)
      }
    }
  }
}

service.interceptors.request.use((request) => {
  const { id } = store.state.app.userInfo
  const lang = store.state.app.language
  const token = sessionStorage.getItem('sxToken')
  request.headers['language'] = lang === 'cn' ? 'zh-CN' : lang === 'en' ? 'en-US' : ''
  if (token) {
    request.headers.token = token
  }
  if (id) {
    request.headers.Pragma = 'no-cache'
    request.headers['Cache-Control'] = 'no-cache, no-store'
    if (request.method !== 'post') {
      if (!request.params) {
        request.params = {}
      }
    } else {
      if (request.toast === undefined) {
        request.toast = true
      }
      if (!request.data) {
        // request.data = {}
      }
    }
    // //是否是文件流
    if (request.responseType === 'blob') {
      request.responseType = 'blob'
    }
  }
  return request
})

service.interceptors.response.use(
  (response) => {
    const { data, config } = response
    const { loading, toast = loading } = config
    showToast(toast, data, '内部错误')
    console.log(response)
    if (data || data.status === '200' || data.access_token || Array.isArray(data) || response.status === 200) {
      return data
    } else {
      return Promise.reject(data)
    }
  },
  (err) => {
    let data = {}
    if ((err.response.status === 401 || err.response.status === '401') && err.response.config.url === process.env.VUE_APP_HOST_URL + process.env.VUE_APP_BASE_URL + '/authentication/form') {
      // eslint-disable-next-line standard/object-curly-even-spacing
      data = { status: '500', message: '用户名密码错误', data: {}}
    } else if (err.response.status === 401 || err.response.status === '401') {
      // eslint-disable-next-line standard/object-curly-even-spacing
      data = { status: '500', message: '登录过期，请重新登录', data: {}}
      store.commit('app/setUserInfo', {})
      store.commit('app/setTabList', [])
      location.href = '#/login'
    } else {
      // eslint-disable-next-line standard/object-curly-even-spacing
      data = { status: '500', message: err.response.data.message, data: { message: '内部错误' }}
    }
    if (data.message === 'Name is duplicated!') {
      data.message = '名称重复！'
    }
    err.data = data
    showToast(true, data, data.data.message)
    return Promise.reject(err)
  }
)
const fetch = options => service.request(options)
export default fetch
