export function getDate(type = null, number = 0) {
  const nowdate = new Date()
  let y, m, d, retrundate
  switch (type) {
    case 'month': // 取number月前、后的时间
      nowdate.setMonth(nowdate.getMonth() + number)
      y = nowdate.getFullYear()
      m = nowdate.getMonth() + 1
      d = nowdate.getDate()
      retrundate = y + '-' + m + '-' + d
      break
    default: // 取当前时间
      y = nowdate.getFullYear()
      m = nowdate.getMonth() + 1
      d = nowdate.getDate()
      retrundate = y + '-' + m + '-' + d
  }
  return retrundate
}
// 防抖
export function _debounce(fn, delay) {
  var delay = delay || 200
  var timer
  return function() {
    var th = this
    var args = arguments
    if (timer) {
      clearTimeout(timer)
    }
    timer = setTimeout(function() {
      timer = null
      fn.apply(th, args)
    }, delay)
  }
}
// 节流
export function _throttle(fn, interval) {
  var last
  var timer
  var interval = interval || 200
  return function() {
    var th = this
    var args = arguments
    var now = new Date()
    if (last && now - last < interval) {
      clearTimeout(timer)
      timer = setTimeout(function() {
        last = now
        fn.apply(th, args)
      }, interval)
    } else {
      last = now
      fn.apply(th, args)
    }
  }
}
