// const TerserPlugin = require('terser-webpack-plugin')
module.exports = {
  publicPath: './', // 部署应用时的根路径(默认'/'),也可用相对路径(存在使用限制)
  outputDir: process.env.outputDir, // 运行时生成的生产环境构建文件的目录(默认''dist''，构建之前会被清除)
  assetsDir: 'assets', // 放置生成的静态资源(s、css、img、fonts)的(相对于 outputDir 的)目录(默认'')
  indexPath: 'index.html', // 指定生成的 index.html 的输出路径(相对于 outputDir)也可以是一个绝对路径。
  // pages: {
  //   index: {
  //     // page 的入口
  //     entry: 'src/index/main.js',
  //     // 模板来源
  //     template: 'public/index.html',
  //     // 在 dist/index.html 的输出
  //     filename: 'index.html',
  //     // 当使用 title 选项时，
  //     // template 中的 title 标签需要是 <title><%= htmlWebpackPlugin.options.title %></title>
  //     title: 'Index Page',
  //     // 在这个页面中包含的块，默认情况下会包含
  //     // 提取出来的通用 chunk 和 vendor chunk。
  //     chunks: ['chunk-vendors', 'chunk-common', 'index']
  //   }
  //   // 当使用只有入口的字符串格式时，
  //   // 模板会被推导为 `public/subpage.html`
  //   // 并且如果找不到的话，就回退到 `public/index.html`。
  //   // 输出文件名会被推导为 `subpage.html`。
  //   // subpage: 'src/subpage/main.js'
  // },
  lintOnSave: process.env.NODE_ENV !== 'production', // 是否在保存的时候检查
  // productionSourceMap: true, // 生产环境是否生成 sourceMap 文件
  css: {
    // extract: true, // 是否使用css分离插件 ExtractTextPlugin
    sourceMap: true, // 开启 CSS source maps
    loaderOptions: {
      sass: {
        data: `
          @import "@/assets/styles/variable.scss";
        `
      }
    } // css预设器配置项
    // modules: false // 启用 CSS modules for all css / pre-processor files.
  },
  productionSourceMap: false,
  devServer: { // 环境配置
    host: 'localhost', // 0.0.0.0
    port: 8000,
    https: false,
    hotOnly: false,
    open: true, // 配置自动启动浏览器
    proxy: { // 配置多个代理(配置一个 proxy: 'http://localhost:4000' )
      '/esbconsole': {
        target: 'http://esb.jiucaiyun.cn',
        pathRewrite: { '^/esbconsole': '/esbconsole' },
        logLevel: 'debug',
        changeOrigin: true
      }
      // '/esb': {
      //   target: 'http://middleware.jiucaiyun.cn',
      //   pathRewrite: { '^/esb': '/esb' },
      //   logLevel: 'debug',
      //   changeOrigin: true
      // },
    }
  },
  configureWebpack: {
    // optimization: {
    //   minimizer: [
    //     new TerserPlugin({
    //       terserOptions: {
    //         compress: {
    //           warnings: false,
    //           drop_console: true,
    //           drop_debugger: true,
    //           pure_funcs: ['console.log']
    //         }
    //       }
    //     })
    //   ]
    // },
    performance: {
      hints: 'warning',
      // 入口起点的最大体积 整数类型（以字节为单位）
      maxEntrypointSize: 50000000,
      // 生成文件的最大体积 整数类型（以字节为单位 300k）
      maxAssetSize: 30000000,
      // 只给出 js 文件的性能提示
      assetFilter: function(assetFilename) {
        return assetFilename.endsWith('.js')
      }
    }
  },
  chainWebpack: config => {
    // // 禁用fork-ts-checker
    // config.plugins.delete('fork-ts-checker')
    // 移除 prefetch 插件
    // config.plugins.delete('prefetch')
    // // 移除 preload 插件
    // config.plugins.delete('preload')
    // // 压缩代码
    // config.when(process.env.NODE_ENV === 'production', config => {
    //   config.optimization.minimize(true)
    // })
    // // 分割代码
    // config.optimization.splitChunks({
    //   chunks: 'all',
    //   minSize: 20000,
    //   minChunks: 1,
    //   // maxAsyncRequests: 30,
    //   // maxInitialRequests: 30,
    //   // enforceSizeThreshold: 50000,
    //   cacheGroups: {
    //     elementUI: {
    //       name: 'chunk-elementUI', // split elementUI into a single package
    //       priority: 10, // the weight needs to be larger than libs and app or it will be packaged into libs or app
    //       enforce: true,
    //       test: /[\\/]node_modules[\\/]_?element-ui(.*)/ // in order to adapt to cnpm
    //     },
    //     basCompoment: {
    //       name: 'chunk-basCompoment', // split elementUI into a single package
    //       priority: 9, // the weight needs to be larger than libs and app or it will be packaged into libs or app
    //       enforce: true,
    //       test: /[\\/]node_modules[\\/]_?bas-component(.*)/ // in order to adapt to cnpm
    //     },
    //     libs: {
    //       name: 'chunk-libs',
    //       test: /[\\/]node_modules[\\/]/,
    //       priority: 8,
    //       enforce: true,
    //       chunks: 'initial' // only package third parties that are initially dependent
    //     },
    //     common: {
    //       name: 'common',
    //       chunks: 'initial',
    //       minChunks: 2,
    //       priority: 8,
    //       enforce: true
    //     }
    //   }
    // })
    // config.optimization.runtimeChunk('single')

    // const jsRule = config.module.rule('js')
    // jsRule.uses.clear()
    // jsRule.use('happypack/loader?id=babel')
    //   .loader('happypack/loader?id=babel')
    //   .end()
    // // 压缩图片
    // config.module
    //   .rule('images')
    //   .use('image-webpack-loader')
    //   .loader('image-webpack-loader')
    //   .options({
    //     bypassOnDebug: true
    //   })
    //   .end()
  },
  pluginOptions: { // 第三方插件配置
    // ...
  }
}
