package com.ekingwin.eit.service.impl;

import com.ekingwin.eit.dao.IEwoPhaseRocketMqDao;

import com.ekingwin.eit.dto.EwoPhaseRocketMqDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zugs
 */

@Service
@Primary
public class EwoPhaseRocketMqServiceImpl   {

//    private void buildDTO(Object ado, Object dto) {
//        EwoPhaseRocketMqDTO adodemo=(EwoPhaseRocketMqDTO)ado;
//        EwoPhaseRocketMqDO dtodemo=(EwoPhaseRocketMqDO)dto;
//        adodemo.setId(dtodemo.getId());
//        adodemo.setName(dtodemo.getName());
//        adodemo.setContext(dtodemo.getContext());
//    }

    @Autowired
    private IEwoPhaseRocketMqDao ewoPhaseRocketMqDao;


//    public  List<Map<String,Object>> getEwoAllData() {
//         List<Map<String, Object>> ewoAllData = this.getEwoAllData();//EWO单子
//        return null;
//    }


    public EwoPhaseRocketMqDTO save(EwoPhaseRocketMqDTO ewoPhaseRocketMqDTO) {
        return null;
    }

    public void delete(String s) {

    }


    public EwoPhaseRocketMqDTO get(String s) {
        return null;
    }



    public  List<Map<String,Object>> getEwoAllData(){
        //先得到一天之内更新的ewo数据
        List<Map<String, Object>> allDatas = ewoPhaseRocketMqDao.getEwoAllData();
        List<Map<String, Object>> ewoInfos=new ArrayList<Map<String, Object>>();
        for ( Map<String, Object> map :allDatas ) {
            String instid=map.get("INSTID")==null?"":map.get("INSTID")+"";
            System.out.println("INSTID====="+instid);
            String myids=map.get("MY")+"";
            String programcodes=map.get("PROGRAMCODE")+"";
            if(StringUtils.isEmpty(myids) || StringUtils.isEmpty(programcodes)
                    || "null".equals(myids) || "null".equals(programcodes) ){
                continue;
            }
            List<Map<String, Object>> myInfos = ewoPhaseRocketMqDao.getMyInfo(myids);
            String myname="";
            if(myInfos!=null && myInfos.size()>0){
                myname=myInfos.get(0).get("MY")+"";
            }

            if(!StringUtils.isEmpty(programcodes) && !"null".equals(programcodes)){
                //系统中是一个my对应多个programcode，现在拆开
                String[] programcodeInfos = programcodes.split(",");
                for (int i=0; i<programcodeInfos.length;i++){
                    String mynametemp=myname;
                    String programcodeid= programcodeInfos[i];
                    List<Map<String, Object>> programCodeInfo = ewoPhaseRocketMqDao.getProgramCodeInfo(programcodeid);
                    if(programCodeInfo!=null && programCodeInfo.size()>0){
                        String prgramcodename= programCodeInfo.get(0).get("PROGRAMCODE")+"";
                        Map<String, Object> ewoInfo=new HashMap<String, Object>()  ;
                        ewoInfo.put("ewoId",map.get("EWONO")+""+myname+prgramcodename);
                        ewoInfo.put("ewoNo",map.get("EWONO")+"");
                        if(!StringUtils.isEmpty(mynametemp)){
                            mynametemp=mynametemp.substring(2,mynametemp.length());
                            ewoInfo.put("modelYear","MY"+mynametemp);
                        }else{
                            ewoInfo.put("modelYear","");
                        }
                        ewoInfo.put("programCode",prgramcodename);
                        //根据id查product名称
                        List<Map<String, Object>> product = new ArrayList<Map<String, Object>>();
                        //根据id查询名称
                        if(map.get("PRODUCT")!=null && !StringUtils.isEmpty(map.get("PRODUCT")+"")  && !"".equals(map.get("PRODUCT").toString()) ){
                             product = ewoPhaseRocketMqDao.getProductInfo(map.get("PRODUCT") + "");
                        }
                        String productname="";
                        if(product!=null && product.size()>0){
                            productname= product.get(0).get("PRODUCT")+"";
                        }
                        ewoInfo.put("product",productname);
                        ewoInfo.put("cabDate",map.get("CABDATE")==null?"":map.get("CABDATE")+"");
                        ewoInfo.put("cabStatus",map.get("CABDECISION")==null?"":map.get("CABDECISION")+"");
                        String phase=map.get("PHASEAFFECT")==null?"":map.get("PHASEAFFECT")+"";
                        String effpoint=map.get("EFFPOINT")==null?"":map.get("EFFPOINT")+"";
                        //对断点阶段处理
                        ewoInfo= handlePhaseAffect(myids,programcodeid,ewoInfo,phase,effpoint,instid);
                        ewoInfos.add(ewoInfo);
                    }
                }
            }else{
                continue;
            }
        }

        return ewoInfos;
    }



    public Map<String,Object> handlePhaseAffect(String myids,String programcodeid, Map<String,Object> ewoInfo,String phase,String  effpoint,String instid){
        ewoInfo.put("phaseAffect", "");
        ewoInfo.put("tid", "");
        if("URGENT".equals(effpoint)){
            List<Map<String, Object>> gzInfo = ewoPhaseRocketMqDao.getGzInfo(instid);
            if(gzInfo!=null && gzInfo.size()>0){
                ewoInfo.put("tid", gzInfo.get(0).get("TID")==null?"":gzInfo.get(0).get("TID")+"");
            }
        }else{
            if(!StringUtils.isEmpty(phase) && !"null".equals(phase)){
                String[] phasedata = phase.split(",");
                for (int j=0;j<phasedata.length;j++){
                    String phasedataSimpleid=phasedata[j];
                    List<Map<String, Object>> PhaseaffectInfo = ewoPhaseRocketMqDao.getPhaseaffectInfo(myids, programcodeid);
                    if(PhaseaffectInfo!=null && PhaseaffectInfo.size()>0){
                        String phasedataids =PhaseaffectInfo.get(0).get("NODEID")+"";
                        if(!StringUtils.isEmpty(phasedataids)){
                            String[] split = phasedataids.split(",");
                            for (int k=0; k<split.length;k++){
                                if(phasedataSimpleid.equals(split[k])){
                                    List<Map<String, Object>> phaseaffectNodeInfo = ewoPhaseRocketMqDao.getPhaseaffectNodeInfo(phasedataSimpleid);
                                    if(phaseaffectNodeInfo!=null && phaseaffectNodeInfo.size()>0){
                                           String nodeno=phaseaffectNodeInfo.get(0).get("NODENO")==null?"":phaseaffectNodeInfo.get(0).get("NODENO")+"";
                                           String nodetype=phaseaffectNodeInfo.get(0).get("NODETYPE")==null?"":phaseaffectNodeInfo.get(0).get("NODETYPE")+"";
                                        ewoInfo.put("phaseAffect",  nodetype+nodeno);
//                                        ewoInfo.put("tid", phaseaffectNodeInfo.get(0).get("PHASEAFFECTDATE")==null?"":phaseaffectNodeInfo.get(0).get("PHASEAFFECTDATE")+"");
                                    }

                                    break;
                                }
                            }

                        }

                    }
                }

            }
        }


        return ewoInfo;
    }

    public void getAllTuzycs(){
        List<Map<String, Object>> allTuzycs = ewoPhaseRocketMqDao.getAllTuzycs();
        System.out.println(allTuzycs);
    }

}
